#include <bits/stdc++.h>
using namespace std;

inline int hexaToDec(char ch) {
	if ('0' <= ch && ch <= '9')
		return ch - '0';
	return ch - 'A' + 10;
}

inline int convert(string str) {
	int nr = 0;
	for (char ch : str)
		nr |= (1 << hexaToDec(ch));
	return nr;
}

void optimOptimizat(void) {
	int cnt[1 << 16];
	memset(cnt, 0, sizeof cnt);
	long long ans = 0;
	for (string str; cin >> str; ) {
		int nr = convert(str);
		ans += cnt[((1 << 16) - 1) ^ nr];
		++cnt[nr];
	}
	cout << ans;	
}

void NLogNcuMap(void) {
	map<int, int> cnt;
	long long ans = 0;
	for (string str; cin >> str; ) {
		int nr = convert(str);
		ans += cnt[((1 << 16) - 1) ^ nr];
		++cnt[nr];
	}
	cout << ans;
}	

void brutOptimizat(void) {
	int val[200005];
	long long ans = 0;
	string str;
	for (int i = 1; cin >> str; ++i) {
		val[i] = convert(str);
		for (int j = i - 1; j >= 1; --j)
			if ((val[i] ^ val[j]) == ((1 << 16) - 1))
				++ans;
	}
	cout << ans;
}

void brutNeoptimizat(void) {
	string val[200005];
	long long ans = 0;
	for (int i = 1; cin >> val[i]; ++i) {
		for (int j = i - 1; j >= 1; --j)
			if (convert(val[i] + val[j]) == ((1 << 16) - 1) && (convert(val[i]) & convert(val[j])) == 0)
				++ans;
	}
	cout << ans;
}

int main(void) {

	freopen("perechi.in", "r", stdin);
	freopen("perechi.out", "w", stdout);

	brutNeoptimizat();

	return 0;
}
